﻿//////////////////////////////////////////////
// ImageEnvironmentEffect.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class System ;
}

namespace nkGraphics
{
	class Program ;
	class Sampler ;
	class Texture ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

#include "../Effect.h"

#include "ImageEnvironmentEffectInfo.h"

/// Class ------------------------------------

namespace nkAstraeus
{
	class DLL_ASTRAEUS_EXPORT ImageEnvironmentEffect final : public Effect
	{
		public :

			// Constructor, destructor
			ImageEnvironmentEffect (System* system) noexcept ;
			virtual ~ImageEnvironmentEffect () ;

			// Getters
			nkGraphics::Texture* getSourceTexture () const ;
			nkGraphics::Sampler* getSourceSampler () const ;
			nkGraphics::Camera* getSourceCamera () const ;
			IMAGE_ENVIRONMENT_PROJECTION getSourceProjection () const ;

			// Setters
			void setSourceTexture (nkGraphics::Texture* value) ;
			void setSourceSampler (nkGraphics::Sampler* value) ;
			void setSourceCamera (nkGraphics::Camera* value) ;
			void setSourceProjection (IMAGE_ENVIRONMENT_PROJECTION value) ;

			// Load
			virtual bool load () override ;
			virtual void unload () override ;

		public :

			// Statics
			// Creation
			static nkMemory::UniquePtr<ImageEnvironmentEffect> create (System* system = nullptr) ;

			// Utilities
			static IMAGE_ENVIRONMENT_PROJECTION getRequiredProjection (const ImageEnvironmentEffectInfo& info) ;

		private :

			// Functions
			// Program
			bool _prepareProgram () ;

			// Shader
			bool _prepareShader () ;

		private :

			// Attributes
			System* _system ;

			// Program
			nkGraphics::Program* _program ;
			ImageEnvironmentEffectInfo _programInfo ;

			// Info
			ImageEnvironmentEffectInfo _info ;
	} ;
}